import { useState, useEffect } from 'react'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import marketing1 from '/images/marketing-1.jpg'
import marketing2 from '/images/marketing-2.jpg'
import marketing3 from '/images/marketing-3.jpg'
import marketing4 from '/images/marketing-4.jpg'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  
  // Заглушки для изображений
  const images = [
    {
      id: 1,
      src: marketing1,
      title: 'Креатив'
    },
    {
      id: 2,
      src: marketing2,
      title: 'Инновации'
    },
    {
      id: 3,
      src: marketing3,
      title: 'Рост'
    },
    {
      id: 4,
      src: marketing4,
      title: 'Успех'
    }
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-creative">
      <div className="slider-wrapper-creative">
        {images.map((img, index) => (
          <div
            key={img.id}
            className={`slide-creative ${index === currentIndex ? 'active' : ''}`}
          >
            <img src={img.src} alt={img.title} className="slide-image-creative" />
            <div className="slide-overlay-creative"></div>
            <div className="slide-content-creative">
              <h3 className="slide-title-creative">{img.title}</h3>
            </div>
          </div>
        ))}
      </div>
      <button className="slider-btn-creative prev-creative" onClick={goToPrevious}>
        <ChevronLeft className="slider-icon-creative" size={28} />
      </button>
      <button className="slider-btn-creative next-creative" onClick={goToNext}>
        <ChevronRight className="slider-icon-creative" size={28} />
      </button>
      <div className="slider-dots-creative">
        {images.map((_, index) => (
          <button
            key={index}
            className={`dot-creative ${index === currentIndex ? 'active' : ''}`}
            onClick={() => goToSlide(index)}
            aria-label={`Go to slide ${index + 1}`}
          />
        ))}
      </div>
    </div>
  )
}

export default ImageSlider

